package refrect_action;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;

import lib.string.JSonUtil;
import models.ContentsBiz;
import servercore.http.HttpRequest;
import servercore.http.HttpResponse;
import servercore.servelet.reflect.Action;
import servercore.http.HttpRequest.METHOD;

public class ContentData extends Action{

	public HttpResponse execute(HttpRequest request) throws Exception {
		HttpResponse res = new HttpResponse();
		METHOD method  = request.getMethod();
		ContentsBiz biz = new ContentsBiz();
		res.addHeader("Cache-Control", "no-cache");
		if(method == METHOD.GET) {
			String idx = request.getGetParams().get("idx");
			if(idx == null || "".equals(idx)) {
				res.setStatusCore(400);
				return res;
			}
			int index = Integer.parseInt(idx);
			HashMap<String,String> map = biz.getData(index);
			String data = JSonUtil.mapToJSON(map);
			res.setResponseStr(data);
		} else if(method == METHOD.POST) {
			String body = request.getPostParams().get("body");
			String title = request.getPostParams().get("title");
			if(title == null || "".equals(title)) {
				res.setStatusCore(400);
				res.setResponseStr("title is null");
				return res;
			}
			if(body == null || "".equals(body)) {
				res.setStatusCore(400);
				res.setResponseStr("body is null");
				return res;
			}
			body = URLDecoder.decode(body, "UTF-8");
			title = URLDecoder.decode(title, "UTF-8");
			HashMap<String, String > data = new HashMap<String, String>();
			data.put("body", body);
			data.put("title", title);
			int ret = biz.insertData(data);
			res.setStatusCore(201);
			res.addHeader("Location", "content_show.html?idx=" + ret);
			res.setResponseStr("content_show.html?idx=" + ret);
		}
		return res;
	}
}
